# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1739-1 (mldonkey)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63604);
 script_cve_id("CVE-2009-0753");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1739-1 (mldonkey)";
 script_name(name);

 desc = "The remote host is missing an update to mldonkey
announced via advisory DSA 1739-1.

It has been discovered that mldonkey, a client for several P2P
networks, allows attackers to download arbitrary files using crafted
requests to the HTTP console.

For the stable distribution (etch), this problem has been fixed in
version 2.9.5-2+lenny1.

For the unstable distribution (sid), this problem will be fixed soon.

The old stable distribution (etch) is not affected by this problem.

We recommend that you upgrade your mldonkey packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201739-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1739-1 (mldonkey)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mldonkey-gui", ver:"2.9.5-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mldonkey-server", ver:"2.9.5-2+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
