# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 269-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53351);
 script_cve_id("CVE-2003-0138");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 269-2 (heimdal)";
 script_name(name);

 desc = "The remote host is missing an update to heimdal
announced via advisory DSA 269-2.

Due to overzealous applied patches, the security update DSA 269-1
introduced problems in some installations, causing the hprop service
to fail.  This is corrected with the update below.

For completeness, here is the original advisory text:

A cryptographic weakness in version 4 of the Kerberos protocol allows
an attacker to use a chosen-plaintext attack to impersonate any
principal in a realm.  Additional cryptographic weaknesses in the krb4
implementation permit the use of cut-and-paste attacks to fabricate
krb4 tickets for unauthorized client principals if triple-DES keys are
used to key krb4 services.  These attacks can subvert a site's entire
Kerberos authentication infrastructure.

This version of the heimdal package changes the default behavior and
disallows cross-realm authentication for Kerberos version 4.  Because
of the fundamental nature of the problem, cross-realm authentication
in Kerberos version 4 cannot be made secure and sites should avoid its
use.  A new option (--kerberos4-cross-realm) is provided to the kdc
command to re-enable version 4 cross-realm authentication for those
sites that must use this functionality but desire the other security
fixes.

For the stable distribution (woody) these problems have been
fixed in version 0.4e-7.woody.8.

The old stable distribution (potato) is not affected by this problem,
since it isn't compiled against kerberos 4.

For the unstable distribution (sid) the original problem has been
fixed in version 0.5.2-1 and since it was a new upstream version did
not contain the problem mentioned above.

We recommend that you upgrade your heimdal packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20269-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 269-2 (heimdal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"heimdal-docs", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-lib", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients-x", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-dev", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-kdc", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers-x", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libasn1-5-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcomerr1-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgssapi1-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libhdb7-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5clnt4-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5srv7-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkafs0-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-17-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libotp0-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libroken9-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsl0-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libss0-heimdal", ver:"0.4e-7.woody.8", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
