///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/scene/objects/ModifierApplication.h>
#include <core/scene/objects/ModifiedObject.h>

namespace Core {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(ModifierApplication, RefTarget)
DEFINE_REFERENCE_FIELD(ModifierApplication, Modifier, "Modifier", _modifier)
SET_PROPERTY_FIELD_LABEL(ModifierApplication, _modifier, "Modifier")

/******************************************************************************
* Default constructor.
******************************************************************************/
ModifierApplication::ModifierApplication(bool isLoading) : RefTarget(isLoading)
{
	INIT_PROPERTY_FIELD(ModifierApplication, _modifier);
}

/******************************************************************************
* Constructor.
******************************************************************************/
ModifierApplication::ModifierApplication(Modifier* mod) : RefTarget(false)
{
	INIT_PROPERTY_FIELD(ModifierApplication, _modifier);
	this->_modifier = mod;
}

/******************************************************************************
* Returns the ModifiedObject this application belongs to.
******************************************************************************/
ModifiedObject* ModifierApplication::modifiedObject() const
{
	Q_FOREACH(RefMaker* dependent, getDependents()) {
        ModifiedObject* modObj = dynamic_object_cast<ModifiedObject>(dependent);
		if(modObj != NULL) return modObj;
	}
	return NULL;
}

/******************************************************************************
* Explicitly sets the status of this modifier application. This
* is an internal function.
******************************************************************************/
void ModifierApplication::setStatus(const EvaluationStatus& status)
{
	if(status == _evalStatus) return;
	_evalStatus = status;
	notifyDependents(REFTARGET_STATUS_CHANGED);
}


};
